<?php

function sm_vtabs_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'vtabs', $view_params );
}

function sm_register_shortcode_handler_sm_vtabs() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		//require_once ( SM_SHORTCODE_CLASS_PATH . 'tabs.php' );
		class WPBakeryShortCode_sm_vtabs extends WPBakeryShortCode_sm_tabs {
			protected $predefined_atts = array(
				'tab_id' => 'Tab',
				'title' => ''
			);
			public function getTabTemplate() {
				return '<div class="wpb_template">' . do_shortcode( '[sm_tab title="Tab" tab_id=""][/sm_tab]' ) . '</div>';
			}
			protected function getFileName() {
				return 'sm_tabs';
			}
			function content($atts, $content = null) {
				return sm_vtabs_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_vtabs', 'sm_vtabs_func' );
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Vertical Tabs', 'semona-extension' ),
	'base' => 'sm_vtabs',
	'show_settings_on_create' => false,
	'is_container' => true,
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'wrapper_class' => 'vc_clearfix',
	'description' => esc_html__( 'Vertical tabbed content', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-vtabs.png',
	'params' => array(
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Widget title', 'semona-extension' ),
				'param_name' => 'title',
				'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'semona-extension' )
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Auto rotate', 'semona-extension' ),
				'param_name' => 'interval',
				'value' => array( esc_html__( 'Disable', 'semona-extension' ) => 0, 3, 5, 10, 15 ),
				'std' => 0,
				'description' => esc_html__( 'Auto rotate vtabs each X seconds.', 'semona-extension' )
			),
			sm_extra_class(),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Tab Style', 'semona-extension' ),
				'param_name' => 'style',
				'description' => esc_html__( 'Select Tab Style.', 'semona-extension' ),
				'value' => sm_get_vtabs_styles_array(),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Outline Style', 'semona-extension' ),
				'param_name' => 'outline_style',
				'description' => esc_html__( 'Select Outline Style.', 'semona-extension' ),
				'value' => sm_get_vtabs_outline_styles_array(),
				'dependency' => array(
					'element' => 'style',
					'value' => array( 'sm-style-outline' )
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Solid Style', 'semona-extension' ),
				'param_name' => 'solid_style',
				'description' => esc_html__( 'Select Solid Style.', 'semona-extension' ),
				'value' => sm_get_skins_array( true ),
				'dependency' => array(
					'element' => 'style',
					'value_not_equal_to' => array( 'sm-style-outline' )
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Content Background Color', 'semona-extension' ),
				'param_name' => 'content_color',
				'description' => esc_html__( 'Select active header background color.', 'semona-extension' ),
				'value' => sm_get_vtabs_content_bg_colors_array(),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'dependency' => array(
					'element' => 'style',
					'value_not_equal_to' => array( 'sm-style-outline' )
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Custom Content Background Color', 'semona-extension' ),
				'param_name' => 'custom_content_bg_color',
				'description' => esc_html__( 'Choose active header border color.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'content_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Custom Content Text Color', 'semona-extension' ),
				'param_name' => 'custom_content_text_color',
				'description' => esc_html__( 'Choose active header border color.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'content_color',
					'value' => array( 'custom' )
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
	),
	'custom_markup' => '
<div class="wpb_tabs_holder wpb_holder vc_clearfix vc_container_for_children">
<ul class="tabs_controls">
</ul>
%content%
</div>'
,
	'default_content' => '
[sm_tab title="' . esc_html__( 'Tab 1', 'semona-extension' ) . '" tab_id="' . ( 'def' . time() . '-1-' . rand( 0, 100 ) ) . '"][/sm_tab]
[sm_tab title="' . esc_html__( 'Tab 2', 'semona-extension' ) . '" tab_id="' . ( 'def' . time() . '-2-' . rand( 0, 100 ) ) . '"][/sm_tab]
',
	'js_view' => 'SMTabsView'
) );

